/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.ExceptionCollector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;

public final class RegionFileStorage
implements AutoCloseable {
    public static final String f_156615_ = ".mca";
    private static final int f_156616_ = 256;
    private final Long2ObjectLinkedOpenHashMap<RegionFile> f_63699_ = new Long2ObjectLinkedOpenHashMap();
    private final Path f_63700_;
    private final boolean f_63701_;

    RegionFileStorage(Path p_196954_, boolean p_196955_) {
        this.f_63700_ = p_196954_;
        this.f_63701_ = p_196955_;
    }

    private RegionFile getRegionFile(ChunkPos p_63712_, boolean existingOnly) throws IOException {
        long i = ChunkPos.m_45589_((int)p_63712_.m_45610_(), (int)p_63712_.m_45612_());
        RegionFile regionfile = (RegionFile)this.f_63699_.getAndMoveToFirst(i);
        if (regionfile != null) {
            return regionfile;
        }
        if (this.f_63699_.size() >= 256) {
            ((RegionFile)this.f_63699_.removeLast()).close();
        }
        Files.createDirectories(this.f_63700_, new FileAttribute[0]);
        Path path = this.f_63700_.resolve("r." + p_63712_.m_45610_() + "." + p_63712_.m_45612_() + f_156615_);
        if (existingOnly && !Files.exists(path, new LinkOption[0])) {
            return null;
        }
        RegionFile regionfile1 = new RegionFile(path, this.f_63700_, this.f_63701_);
        this.f_63699_.putAndMoveToFirst(i, (Object)regionfile1);
        return regionfile1;
    }

    @Nullable
    public CompoundTag m_63706_(ChunkPos p_63707_) throws IOException {
        CompoundTag compoundtag;
        block8: {
            CompoundTag compoundtag2;
            RegionFile regionfile = this.getRegionFile(p_63707_, true);
            if (regionfile == null) {
                return null;
            }
            try (DataInputStream datainputstream = regionfile.m_63645_(p_63707_);){
                if (datainputstream == null) {
                    compoundtag = null;
                    break block8;
                }
                compoundtag2 = NbtIo.m_128928_(datainputstream);
            }
            return compoundtag2;
        }
        return compoundtag;
    }

    public void m_196956_(ChunkPos p_196957_, StreamTagVisitor p_196958_) throws IOException {
        RegionFile regionfile = this.getRegionFile(p_196957_, true);
        if (regionfile == null) {
            return;
        }
        try (DataInputStream datainputstream = regionfile.m_63645_(p_196957_);){
            if (datainputstream != null) {
                NbtIo.m_197509_(datainputstream, p_196958_);
            }
        }
    }

    protected void m_63708_(ChunkPos p_63709_, @Nullable CompoundTag p_63710_) throws IOException {
        RegionFile regionfile = this.getRegionFile(p_63709_, false);
        if (p_63710_ == null) {
            regionfile.m_156613_(p_63709_);
        } else {
            try (DataOutputStream dataoutputstream = regionfile.m_63678_(p_63709_);){
                NbtIo.m_128941_(p_63710_, dataoutputstream);
            }
        }
    }

    @Override
    public void close() throws IOException {
        ExceptionCollector exceptioncollector = new ExceptionCollector();
        for (RegionFile regionfile : this.f_63699_.values()) {
            try {
                regionfile.close();
            }
            catch (IOException ioexception) {
                exceptioncollector.m_13653_((Throwable)ioexception);
            }
        }
        exceptioncollector.m_13652_();
    }

    public void m_63705_() throws IOException {
        for (RegionFile regionfile : this.f_63699_.values()) {
            regionfile.m_63637_();
        }
    }
}

